import { BaseConnection, type SessionConfig, type FormatConfig } from "./BaseConnection";
import { type OutgoingSocketEvent } from "./events";
export declare class WebSocketConnection extends BaseConnection {
    private readonly socket;
    readonly conversationId: string;
    readonly inputFormat: FormatConfig;
    readonly outputFormat: FormatConfig;
    private constructor();
    static create(config: SessionConfig): Promise<WebSocketConnection>;
    close(): void;
    sendMessage(message: OutgoingSocketEvent): void;
    setMicMuted(isMuted: boolean): Promise<void>;
}
